/*
 * Controlling MCP3208 ADC by SPI (using spidev driver)
 *
 * Copyright (c) 2007  MontaVista Software, Inc.
 * Copyright (c) 2007  Anton Vorontsov <avorontsov@ru.mvista.com>
 *
 * Modifications 2012 by Claus Knel <info@ckuehnel.ch>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License.
 *
 * The orignal source is http://sourceforge.net/projects/raspberrypisnip/files/C/mcp3208.c/download
 *
 * 2014/7-2015/7
 * Modifications For getting by CSV type file by Hiroshima-gas TRI (AN).
 * 2017/4/12 Adding to support chsetting.csv
 * 2017/9/25 repair main loop
 *
 * (Example) Compile on Raspberry Pi by gcc am73.c -o am
 */

#include <stdint.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include <linux/spi/spidev.h>
#include <time.h>
#include <sys/time.h>

#include "alarm_mail8.h"

#define ARRAY_SIZE(a) (sizeof(a) / sizeof((a)[0]))

#define DEBUG 0

// Configuration bits for single-ended channel selection
#define CHANNEL0 0x060000   // Channel 0
#define CHANNEL1 0x064000   // Channel 1
#define CHANNEL2 0x068000   // Channel 2
#define CHANNEL3 0x06C000   // Channel 3
#define CHANNEL4 0x070000   // Channel 4
#define CHANNEL5 0x074000   // Channel 5
#define CHANNEL6 0x078000   // Channel 6
#define CHANNEL7 0x07C000   // Channel 7

static const char *device0 = "/dev/spidev0.0";
static const char *device1 = "/dev/spidev0.1";
static uint8_t mode;
static uint8_t bits = 8;
static uint32_t speed = 500000;
static uint16_t delay;

uint32_t channel;
char currentdir[100] = "/usr/local/measure/am";
static const int OPT_R_MAX = 1800;			//measure interval max 1800 sec (30 minutes)
static const int cenr = 0;				//using 0:CE0 1:CE1
char mbody[10][255];					//alarm mail body part

FILE *fp10;
char *fname10 = "../set/am.setting";		//analog measure setting file
int mchno[8][2];    				//Channel number(0-7) and Instrumentation signal type 0:0-5V 1:1-5V
char mname[8][31]; 				//the measure name of every channel
char munit[8][21]; 				//uint
float massign[8][2];				//lower and upper assign
int aat[8];					//Analog alarm type 0:none 1:upper limit 2:lower limit 3:upper and lower limits
float aul[8];					//Analog upper limit
float all[8];					//Analog lower limit
float amvalue[8];				//measure value corrected by low and high assign

FILE *fp20;
char *fname20 = "../set/measure.setting";	//general measure setting file
int intervalsec[4];				//analog measure interval(sec)
char am_name[4][51];				//analog measure project name
int spanrev[4];					//MCP3208's Vref Voltage(mV) for span-control: Usually fix 5000

FILE *fp30;
char *fname30 = "am_header.txt";		//header text of logging data

FILE *fp40;
char *fname40 = "../tempdata/am.csv";		//logging data before FTP upload
char amtime[100];

FILE *fp70;
char *fname70 = "../log/alarm_log/am_alarm.log";	//alarm logging file
time_t date_old[8][3];					//time-memories when alarm occurrence
int moa[8][3];						//memories of alarm every channel
int uorl;						//memory of alarm detecrion
time_t nowtime;						//time of alarm occurrence
time_t mailtime[8];					//memory of alarm-mail sending time
int sec_time;						//prohibition period of a next send mail
int firsta[8];						//memory of the first sending alarm mail
float amvaluex;						//temporary date of measure value

FILE *fp80;
char *fname80 = "../ping/chsetting.csv";	//file of recording setting file change
int chset[10];					//change presence:1 or absence:0
char chset_name[12];				//csv 1st term

/* recording alarm */
int alarm_record(int chno,int uorl)
{

    int rows = 0,rowsx =0 ;
    char buffx[256];

    fp70 = fopen (fname70,"a");
    if (fp70 == NULL) {
	printf("%s ファイルが開けません\n",fname70);
	return -1;
    }

    switch (uorl) {
	case 1:
		fprintf (fp70,"AM_Ch%d,%s,Upper level alarm,%s,%d,%g,%g,%g,%s\n",mchno[chno][0],amtime,&mname[chno],aat[chno],aul[chno],all[chno],amvalue[chno],&munit[chno]);
		break;
	case 2:
		fprintf (fp70,"AM_Ch%d,%s,Lower level alarm,%s,%d,%g,%g,%g,%s\n",mchno[chno][0],amtime,&mname[chno],aat[chno],aul[chno],all[chno],amvalue[chno],&munit[chno]);
		break;
    }

   if ((moa[chno][0] == 1) && (moa[chno][1] == 1) && (moa[chno][2] == 1)) {
	date_old[chno][0] = date_old[chno][1];
	date_old[chno][1] = date_old[chno][2];
	date_old[chno][2] = nowtime;
    }

    if ((moa[chno][0] == 1) && (moa[chno][1] == 1) && (moa[chno][2] == 0)) {
	moa[chno][2] = 1;
	date_old[chno][2] = nowtime;
    }

    if ((moa[chno][0] == 1) && (moa[chno][1] == 0)) {
	moa[chno][1] = 1;
	date_old[chno][1] = nowtime;
    }

    if (moa[chno][0] == 0) {
	moa[chno][0] = 1;
	date_old[chno][0] = nowtime;
    }

    if (intervalsec[0] <= 180) sec_time = 1800;
    if ((intervalsec[0] > 180) && (intervalsec[0] <= 600)) sec_time = 3600;
    if (intervalsec[0] >= 600) sec_time = 7200;

    if ((moa[chno][2] == 1) && (date_old[chno][2]-date_old[chno][0] <= sec_time)) {

	sprintf(mbody[0], "アナログ計測「 %s 」にて %d (秒) 以内に3回以上の警報が発生しています。\n", &am_name[0],sec_time);
	sprintf(mbody[1], "\n");
	sprintf(mbody[2], "----------------直近のアラームデータ----------------\n");
	switch(uorl) {
		case 1:
			sprintf(mbody[3],"「上限警報発生」  日時: %s\n",amtime);break;
		case 2:
 			sprintf(mbody[3],"「下限警報発生」  日時: %s\n",amtime);break;
	}
	sprintf(mbody[4],"AM_Ch%d : %s\n",mchno[chno][0],&mname[chno]);
	sprintf(mbody[5],"警報発生時の測定値 : %g(%s)\n",amvalue[chno],&munit[chno]);
	sprintf(mbody[6],"\n");
	sprintf(mbody[7],"----------------------警報設定値---------------------\n");
	switch (aat[chno]) {
		case 1:
			sprintf(mbody[8],"上限警報: %g(%s)\n",aul[chno],&munit[chno]);break;
		case 2:
			sprintf(mbody[8],"下限警報: %g(%s)\n",all[chno],&munit[chno]);break;
		case 3:
			sprintf(mbody[8],"上下限警報:上限 %g(%s),下限 %g(%s)\n",aul[chno],&munit[chno],all[chno],&munit[chno]);
			break;
	}

	if (firsta[chno] == 0) {
		alarm_mail(mbody);
		firsta[chno] = 1;
		mailtime[chno] = nowtime;
		fprintf (fp70,"%s,sent alarm mail\n",amtime);
		moa[chno][0]=0;
		moa[chno][1]=0;
		moa[chno][2]=0;
	}

	if (firsta[chno] != 0) {
		if (mailtime[chno] + sec_time <= nowtime) {
			alarm_mail(mbody);
			mailtime[chno] = nowtime;
			fprintf (fp70,"%s,sent alarm mail\n",amtime);
			moa[chno][0]=0;
			moa[chno][1]=0;
			moa[chno][2]=0;
		}
	}

   }


	/* Adjust alarm-log length */

	while (fgets( buffx,256, fp70) != NULL ) rows++;		//count rows of alarm-log
	fclose(fp70);
	rowsx = rows;

	if (rowsx >= 500) {
		FILE *fp75;
		char *fname75="../log/alarm_log/adjustam.txt";	//temporary file for alarm log adjusting
		fp70 = fopen(fname70,"r");
		fp75 = fopen(fname75,"w");
		rows =0;

		while (fgets (buffx,256,fp70) != NULL ){
			if (rows >= rowsx -200) fprintf (fp75,buffx);
				rows++;
		}

		fclose(fp70);
		fclose(fp75);
		remove (fname70);
		rename (fname75,fname70);
		remove (fname75);
	}

}


static void pabort(const char *s)
{
	perror(s);
	abort();
}

static void transfer(int fd,int mchno2,float massign1,float massign2)
{
	uint16_t adc;
	uint8_t ret,i;

	uint8_t tx[3]; 		// 3 bytes will be sent to MPC3208
	uint8_t rx[ARRAY_SIZE(tx)] = {0, };

	float adcmv;

	for (i = 0; i < ARRAY_SIZE(tx); i++)
  	{
      	tx[ARRAY_SIZE(tx)-i-1] = channel%256;
      	channel = channel >> 8;
  	}

	struct spi_ioc_transfer tr =
	{
		.tx_buf = (unsigned long)tx,
		.rx_buf = (unsigned long)rx,
		.len = ARRAY_SIZE(tx),
		.delay_usecs = delay,
		.speed_hz = speed,
		.bits_per_word = bits,
	};

	ret = ioctl(fd, SPI_IOC_MESSAGE(1), &tr);
	if (ret < 1)
		pabort("can't send spi message");


    adc = (rx[1] << 8) + rx[2];
	adc &= 0xFFF;


	adcmv = adc *spanrev[0]/4096;
        //adcmv = adc * 5000/4096;

	switch (mchno2){
	case 0:
		amvaluex = ((massign2-massign1)/5)*adcmv/1000+massign1;
		break;
	case 1:
		amvaluex = ((massign2-massign1)/4)*adcmv/1000+(5*massign1-massign2)/4;
		break;
	}
}


int transfer2()
{
int ret = 0;
int fd;
int j;

	switch (cenr) {
		case 0:fd = open(device0, O_RDWR);break;
		case 1:fd = open(device1, O_RDWR);break;
	}

	if (fd < 0)
		pabort("can't open device");

	 // max speed hz
	ret = ioctl(fd, SPI_IOC_WR_MAX_SPEED_HZ, &speed);
	if (ret == -1)
		pabort("can't set max speed hz");

	ret = ioctl(fd, SPI_IOC_RD_MAX_SPEED_HZ, &speed);
	if (ret == -1)
		pabort("can't get max speed hz");

#if DEBUG
	printf("spi device: %s\n", device);

	printf("spi mode: %d\n", mode);
	printf("bits per word: %d\n", bits);
	printf("max speed: %d Hz (%d KHz)\n", speed, speed/1000);
#endif

	fp40 = fopen(fname40, "a" );
  	if( fp40 == NULL ){
        	printf( "%s ファイルが開けません\n", fname40 );
        	return -1;
  	}

	for (j=0; j<8; j++){
		switch (j){
			case 0:channel = CHANNEL0;break;
			case 1:channel = CHANNEL1;break;
			case 2:channel = CHANNEL2;break;
			case 3:channel = CHANNEL3;break;
			case 4:channel = CHANNEL4;break;
			case 5:channel = CHANNEL5;break;
			case 6:channel = CHANNEL6;break;
			case 7:channel = CHANNEL7;break;
		}
		transfer(fd,mchno[j][1],massign[j][0],massign[j][1]);
		amvalue[j] = amvaluex;
		if (j == 0) fprintf(fp40,"%s,",amtime);
		if ( j < 7 ){
			fprintf(fp40,"%g,",amvalue[j]);
		}else{
			fprintf(fp40,"%g\n",amvalue[j]);
		}

		// Alarm detection
		switch (aat[j]) {
		case 1:
			if (amvalue[j] > aul[j]) alarm_record(j,1);
			break;
 		case 2:
			if (amvalue[j] < all[j]) alarm_record(j,2);
			break;
		case 3:
			if (amvalue[j] > aul[j]) alarm_record(j,1);
			if (amvalue[j] < all[j]) alarm_record(j,2);
			break;
		}

	}

	fclose(fp40);
	close(fd);

}

/* read setting data */
int readsetting()
{
 int ret10,i10;
 int ret20,i20;
 int xxx1[4];

  fp10 = fopen( fname10, "r" );
  if( fp10 == NULL ){
	printf( "%s ファイルが開けません\n", fname10 );
	return -1;
  }
  for (i10 = 0; i10 < 8; i10++)
        {
        ret10 = fscanf( fp10, "%d,%d,%[^,],%[^,],%f,%f,%d,%f,%f", &mchno[i10][0], &mchno[i10][1], &mname[i10][0],&munit[i10][0], &massign[i10][0], &massign[i10][1],&aat[i10],&aul[i10],&all[i10]);
        }
  fclose (fp10);

  fp20 = fopen( fname20, "r" );
  if( fp20 == NULL ){
	printf( "%s ファイルが開けません\n", fname20 );
	return -1;
  }

  for (i20=0;i20<4;i20++) {
	ret20 = fscanf( fp20, "%d,%d,%[^,],%d", &xxx1[i20], &intervalsec[i20], &am_name[i20][0] ,&spanrev[i20] );
  }
  fclose(fp20);
  if (intervalsec[0] > OPT_R_MAX) {
  	printf("計測間隔設定エラー\n");
  return -1;
  }

}



/* make header of csv data file */
int makeheader(){

  char *str30 = "chnr,mode,measure_point,unit,low_assign,high_assign,alarm_type,upper_limit,lower_limit\n";
  char *str31 = "* mode 0: 0-5V  , mode 1: 1-5V\n";
  char *str32 = "* alarm_type 0:None 1:Upper limit alarm 2:Lower limit alarm 3:Upper and lower limits\n";
  int i10;

  fp30 = fopen(fname30,"w");
  if (fp30 == NULL ){
	printf("%sファイルが開けません\n",fname30);
	return -1;
  }

  fprintf(fp30, "%s",&am_name[0]);
  fputs("\n",fp30);
  fputs("\n",fp30);

  fputs (str30,fp30);
  for (i10 = 0; i10 < 8; i10++)
	{
  	fprintf(fp30, "%d,%d,%s,%s,%g,%g,%d,%g,%g", mchno[i10][0], mchno[i10][1], &mname[i10][0], &munit[i10][0], massign[i10][0], massign[i10][1],aat[i10],aul[i10],all[i10]);
  	fputs("\n",fp30);
	}

  fputs("\n",fp30);
  fputs (str31,fp30);
  fputs (str32,fp30);
  fprintf (fp30, "* Span revison level (usually 5000):  %d\n",spanrev[0]);
  fputs("\n",fp30);

  fprintf(fp30, " ,Ch%d,Ch%d,Ch%d,Ch%d,Ch%d,Ch%d,Ch%d,Ch%d\n",mchno[0][0],mchno[1][0],mchno[2][0],mchno[3][0],mchno[4][0],mchno[5][0],mchno[6][0],mchno[7][0]);
  fprintf(fp30, "%s,%s,%s,%s,%s,%s,%s,%s,%s\n", "Date", &mname[0][0],&mname[1][0],&mname[2][0],&mname[3][0],&mname[4][0],&mname[5][0],&mname[6][0],&mname[7][0] );
  fprintf(fp30, " ,(%s),(%s),(%s),(%s),(%s),(%s),(%s),(%s)\n", &munit[0][0], &munit[1][0], &munit[2][0], &munit[3][0], &munit[4][0], &munit[5][0], &munit[6][0], &munit[7][0] );

  fclose (fp30);

  return 0;
}

int chsetting_check() {

	int ret80;
        fp80 = fopen (fname80,"r");
        ret80 = fscanf(fp80,"%[^,],%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",&chset_name,&chset[0],&chset[1],&chset[2],&chset[3],&chset[4],&chset[5],&chset[6],&chset[7],&chset[8],&chset[9]);
        fclose(fp80);
        if (chset[0] == 1 || chset[5] == 1 ){
                readsetting();
                makeheader();
                chset[0] = 0;
                chset[5] = 0;
                fp80 = fopen (fname80,"w");
                fprintf(fp80,"%s,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",&chset_name,chset[0],chset[1],chset[2],chset[3],chset[4],chset[5],chset[6],chset[7],chset[8],chset[9]);
                fclose (fp80);
        }
}

int init_chsetting_check() {

        int ret80;
        fp80 = fopen (fname80,"r");
        ret80 = fscanf(fp80,"%[^,],%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",&chset_name,&chset[0],&chset[1],&chset[2],&chset[3],&chset[4],&chset[5],&chset[6],&chset[7],&chset[8],&chset[9]);
        fclose(fp80);

     	chset[0] = 0;
  	chset[5] = 0;
    	fp80 = fopen (fname80,"w");
    	fprintf(fp80,"%s,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",&chset_name,chset[0],chset[1],chset[2],chset[3],chset[4],chset[5],chset[6],chset[7],chset[8],chset[9]);
      	fclose (fp80);

}

int main(int argc, char *argv[])
{
   struct timeval utimer;
   struct tm *timer;

   chdir(currentdir);
   readsetting();
   makeheader();
   init_chsetting_check();

// order to be started measure loop
   while(1) {

	gettimeofday(&utimer,NULL);
	timer=localtime(&utimer.tv_sec);
	if (utimer.tv_sec%intervalsec[0] == 0) {
		sprintf(amtime,"%d/%d/%d %02d:%02d:%02d",
			timer->tm_year+1900,
			timer->tm_mon+1,
			timer->tm_mday,
			timer->tm_hour,
			timer->tm_min,
			timer->tm_sec);
		transfer2();
	}

	chsetting_check();
	sleep(intervalsec[0]-1);
	usleep(1000000-400);
   }

chdir("/");
return 0;
}
