#!/usr/bin/perl --

use Time::Local;

# receive data from html-form.

if ($ENV{'REQUEST_METHOD'} eq 'GET') {
	$buffer = $ENV{'QUERY_STRING'};
#} else {
#	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
}

foreach $data (split(/&/, $buffer)) {
        ($key, $value) = split(/=/, $data);

        $value =~ s/\+/ /g;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack('C', hex($1))/eg;
        $value =~ s/\t//g;

        $in{"$key"} = $value;
}

if ($in{'am'}) {
        $selectmeasure = 0;
} elsif ($in{'pc'}){
	$selectmeasure = 1;
} elsif ($in{'tca'}){
        $selectmeasure = 2;
} elsif ($in{'tcs'}){
        $selectmeasure = 3;
} elsif ($in{'trh'}){
        $selectmeasure = 4;
}

@selectrenew=($in{'renew0'},$in{'renew1'},$in{'renew2'},$in{'renew3'},$in{'renew4'});

# setting cgi

if ($selectmeasure == 0) {
	$file10 = "/usr/local/measure/tempdata/am.csv";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$row_testname = 1;
	$row_chno = 17;
	$row_mname = 18;
	$row_munit = 19;
	$project_name ="アナログ計測";
}

if ($selectmeasure == 1) {
	$file10 = "/usr/local/measure/tempdata/pc.csv";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$row_testname = 1;
	$row_chno = 13;
	$row_mname = 14;
	$row_munit = 15;
	$project_name ="パルス計測";
}

if ($selectmeasure == 2) {
	$file10 = "/usr/local/measure/tempdata/tca.csv";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$row_testname = 1;
	$row_chno = 17;
	$row_mname = 18;
	$row_munit = 19;
	$project_name ="熱電対計測（アナログ）";
}

if ($selectmeasure == 3) {
	$file10 = "/usr/local/measure/tempdata/tcs.csv";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$row_testname = 1;
	$row_chno = 12;
	$row_mname = 13;
	$row_munit = 14;
	$project_name ="熱電対計測(SPI)";
}


if ($selectmeasure == 4) {
	$file10 = "/usr/local/measure/tempdata/trh.csv";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$row_testname = 1;
	$row_chno = 12;
	$row_mname = 11;
	$row_munit = 14;
	$project_name ="温湿度計測(専用センサー)";
}


if ( -e $file10 ) { $fe10 = 1;}
	
if ($fe10 = 1) {

	$count = 0;
	$countx = 0;

	open ( FH10,"< $file10" );
	while (<FH10>){
		chomp;
		$count++;
		if ($count == $row_testname )  { @testname = split (/,/, $_); }
		if ($count == $row_chno ) { @chno = split (/,/, $_); }
		if ($count == $row_mname ) { @mname = split (/,/, $_); }
		if ($count == $row_munit ) { @munit = split (/,/, $_); }
	}
	$records = $count - $row_munit ;
	close (FH10);

	open ( FH10,"< $file10" );
	while (<FH10>) {
		chomp;
		$countx++;
		if ($countx == $count-1) { @lastrowx =split (/,/, $_);}
		if ($countx == $count) { @lastrow =split (/,/, $_);}
	}
	close(FH10);

	# research difference bitween present time and last measure time
	($yyyy, $mm, $dd, $HH, $MM, $ss) = ( $lastrow[0] =~ /(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);
	if ( defined($yyyy) ){
		$timell = timelocal ($ss, $MM, $HH, $dd,$mm - 1, $yyyy);
		$sec_interval = time - $timell ;
		if ($sec_interval >= 3605) {$err10 = 1;}

		if  ($selectrenew[$selectmeasure] == "a") {
			# research measure interval and define web's refresh interval 
			($yyyy, $mm, $dd, $HH, $MM, $ss) = ( $lastrowx[0] =~ /(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);
			my $timellx = timelocal ($ss, $MM, $HH, $dd,$mm - 1, $yyyy);
			my $sec_intervalx = $timell - $timellx;
			if ($sec_intervalx <= 5) {$refresh_interval = 10 ;}
			if (($sec_intervalx <= 20) and ($sec_intervalx > 5))  {$refresh_interval = 30 ;}
			if (($sec_intervalx <= 40) and ($sec_intervalx > 20)) {$refresh_interval = 60 ;}
			if (($sec_intervalx <= 180) and ($sec_intervalx > 40)) {$refresh_interval = 120 ;}
			if ($sec_intervalx > 180) {$refresh_interval = 600 ;}
		} 
		elsif ($selectrenew[$selectmeasure] == "2") { $refresh_interval = 2;}
		elsif ($selectrenew[$selectmeasure] == "5") { $refresh_interval = 5;} 
		elsif ($selectrenew[$selectmeasure] == "10") { $refresh_interval = 10;}
		elsif ($selectrenew[$selectmeasure] == "30") { $refresh_interval = 30;} 
		elsif ($selectrenew[$selectmeasure] == "60") { $refresh_interval = 60;}
		elsif ($selectrenew[$selectmeasure] == "120") { $refresh_interval = 120;} 
		elsif ($selectrenew[$selectmeasure] == "600") { $refresh_interval = 600;}
	} else {
		$err11 = 1;
	}
}

print <<"HEAD";

        <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
        <html lang="ja">
        <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <meta http-equiv="content-style-type" content="text/css">
        <meta name="viewport" content="width=device-width,initial-scale=1.0">
        <meta http-equiv='Refresh' content='$refresh_interval'>

HEAD

print <<"HEAD2";
	<title>$project_name</title>
	</head>
	<body> 
	<h2>$project_name</h2>
HEAD2

if ($err10 == 1) {
	print " (エラー) 前回の計測から1時間以上経過しています。<br>計測中か確認してください。<br>";
	print "--------------------------------------<br>";
	print '<a href="../">TOPページ</a>へ戻る。<br>';
 	print "</body></html>";
}

if ($err11 == 1) {
	print "　(エラー)　FTPアップロード直後のため、表示できるデータがありません。<br>しばらくお待ちください。<br>";
	print "--------------------------------------<br>";
	print '<a href="../">TOPページ</a>へ戻る。<br>';
	print "</body></html>";
}

if ($fe10 == 0) {
	print " (エラー) [$project_name] の計測値を表示できません。<br>$file10 が存在していません。<br> ";
	print "--------------------------------------<br>";
	print '<a href="../">TOPページ</a>へ戻る。<br>';
	print "</body></html>";
}

if ( $fe10 == 1 and $err10 == 0 and $err11 == 0 ) {

print <<"TBL";

	[ $testname[0] ] <br>
	最新計測日時：   $lastrow[0]<br>
	最新計測日時から $sec_interval 秒経過しています。<br>
	<p>
	<table border="0">
		<tr><th>ChNo.</th><th>計測名</th><th>計測値</th><th>単位</th></tr>
		<tr><td>$chno[1]</td><td> $mname[1] </td><td align="right"> $lastrow[1]</td><td> $munit[1]</td></tr>
		<tr><td>$chno[2]</td><td> $mname[2] </td><td align="right"> $lastrow[2]</td><td> $munit[2]</td></tr>
		<tr><td>$chno[3]</td><td> $mname[3] </td><td align="right"> $lastrow[3]</td><td> $munit[3]</td></tr>
		<tr><td>$chno[4]</td><td> $mname[4] </td><td align="right"> $lastrow[4]</td><td> $munit[4]</td></tr>
		<tr><td>$chno[5]</td><td> $mname[5] </td><td align="right"> $lastrow[5]</td><td> $munit[5]</td></tr>
		<tr><td>$chno[6]</td><td> $mname[6] </td><td align="right"> $lastrow[6]</td><td> $munit[6]</td></tr>
		<tr><td>$chno[7]</td><td> $mname[7] </td><td align="right"> $lastrow[7]</td><td> $munit[7]</td></tr>
		<tr><td>$chno[8]</td><td> $mname[8] </td><td align="right"> $lastrow[8]</td><td> $munit[8]</td></tr>
	</table>
	</p>
	データ数:  $records <br>
	<br>
	このページは、$refresh_interval秒間隔で自動更新されます。<br>
        --------------------------------------<br>
        <a href="../">TOPページ</a>へ戻る。<br>
	</body></html>
TBL

}

exit;
