#!/usr/bin/perl --

use Time::Local;

# receive data from html-form.

if ($ENV{'REQUEST_METHOD'} eq 'GET') {
	$buffer = $ENV{'QUERY_STRING'};
#} else {
#	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
}

foreach $data (split(/&/, $buffer)) {
        ($key, $value) = split(/=/, $data);

        $value =~ s/\+/ /g;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack('C', hex($1))/eg;
        $value =~ s/\t//g;

        $in{"$key"} = $value;
}

if ($in{'renew20'} == '0') {
	$file10 = "/usr/local/measure/log/alarm_log/am_alarm.log";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$project_name = "アラームログ アナログ計測";
}elsif ($in{'renew20'} == '1') {
	$file10 = "/usr/local/measure/log/alarm_log/pc_alarm.log";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$project_name = "アラームログ パルス計測";
} elsif ($in{'renew20'} == '2') {
	$file10 = "/usr/local/measure/log/alarm_log/tcs_alarm.log";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$project_name = "アラームログ 熱電対計測（アナログ）";
} elsif ($in{'renew20'} == '3') {
	$file10 = "/usr/local/measure/log/alarm_log/tcs_alarm.log";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$project_name = "アラームログ 熱電対計測(SPI)";
} elsif ($in{'renew20'} == '4') {
	$file10 = "/usr/local/measure/log/alarm_log/trh_alarm.log";
	$fe10 = 0;
	$err10 = 0;
	$err11 = 0;
	$project_name = "アラームログ 温湿度計測（専用センサー）";
}


if ( -e $file10 ) { $fe10 = 1;}

if ($fe10 = 1) {

	$count = 0;
	$countx = 0;

	open ( FH10,"< $file10" );
	while (<FH10>){
		chomp;
		$count++;
	}
	$records = $count;
	close (FH10);

	
	open ( FH10,"< $file10" );
	if ($count >= 3) {	
		while (<FH10>) {
			chomp;
			$countx++;
			if ($countx == $count-2) { @lastrowx2 = split (/,/, $_);}
			if ($countx == $count-1) { @lastrowx =split (/,/, $_);}
			if ($countx == $count) { @lastrow =split (/,/, $_);}
		}
	} elsif ($count == 2) {
		while (<FH10>) {
			chomp;
			$countx++;
			if ($countx == 2) { @lastrowx =split (/,/, $_);}
			if ($countx == 1) { @lastrow =split (/,/, $_);}
		}
	} elsif ($count == 1) {
		while (<FH10>) {
			chomp;
			$countx++;
			if ($countx == 1) { @lastrow =split (/,/, $_);}
		}
	}
	close(FH10);

	# research difference bitween present time and last measure time
	($yyyy, $mm, $dd, $HH, $MM, $ss) = ( $lastrow[1] =~ /(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);

	if ( defined($yyyy) ){
		$timell = timelocal ($ss, $MM, $HH, $dd,$mm - 1, $yyyy);
		$sec_interval = time - $timell ;
		if ($sec_interval >= 259205) {$err10 = 1;}
		$refresh_interval = 30 ;		
	} else {
		$err11 = 1;
	}
}

print <<"HEAD";

        <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
        <html lang="ja">
        <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <meta http-equiv="content-style-type" content="text/css">
        <meta name="viewport" content="width=device-width,initial-scale=1.0">
        <meta http-equiv='Refresh' content='$refresh_interval'>

HEAD

print <<"HEAD2";
	<title>$project_name</title>
	</head>
	<body> 
	<h2>$project_name</h2>
HEAD2

if ($err10 == 1) {
	print " (エラー) 前回のアラーム記録から72時間以上経過しています。<br>直近のアラームは発生していません。<br>";
	print "--------------------------------------<br>";
	print '<a href="../">TOPページ</a>へ戻る。<br>';
 	print "</body></html>";
}

if ($err11 == 1) {
	print "　(エラー)　アラームログに表示できるデータがありません。<br>アラーム発生後に確認してください。<br>";
	print "--------------------------------------<br>";
	print '<a href="../">TOPページ</a>へ戻る。<br>';
	print "</body></html>";
}

if ($fe10 == 0) {
	print " (エラー) [$project_name] を表示できません。<br>$file90 が存在していません。<br> ";
	print "--------------------------------------<br>";
	print '<a href="../">TOPページ</a>へ戻る。<br>';
	print "</body></html>";
}

if ( $fe10 == 1 and $err10 == 0 and $err11 == 0 ) {
	($yyyy, $mm, $dd, $HH, $MM, $ss) = ( $lastrow[0] =~ /(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);
	if(defined($yyyy)) {
		print "<p>";
		print "-----警報メール送信-----<br>";
	        print "<table border='0'>";
	        print "<tr><td>送信日時 :</td><td>$lastrow[0]</td></tr>";
	        print "</table>";
		print "</p>";
	} else {
		print "<p>";
		print "-----直近 アラームデータ-----<br>";
		print "<table border='0'>";
		print "<tr><td>$lastrow[2]</td><td></td></tr>";
		print "<tr><td>発生日時 :</td><td>$lastrow[1]</td></tr>";
        	print "<tr><td>$lastrow[0] :</td><td>$lastrow[3]</td></tr>";
		print "<tr><td>警報発生時の計測値 :</td><td>$lastrow[7]($lastrow[8])</td></tr>";
		print "</table>";
		print "---------警報設定値----------<br>";
		print "<table border='0'>";
		if ( $lastrow[4] == 1 ) {
			print "<tr><td>上限警報 :</td><td>上限 $lastrow[5]($lastrow[8])</td></tr>";
		} elsif ( $lastrow[4] == 2 ) {
			print "<tr><td>下限警報 :</td><td>下限 $lastrow[6]($lastrow[8])</td></tr>";
		} elsif ( $lastrow[4] == 3 ) {
			print "<tr><td>上下限警報 :</td><td>上限 $lastrow[5]($lastrow[8]),下限 $lastrow[6]($lastrow[8])</td></tr>";
		}
        	print "</table>";
		print "</p>";	
	}

	if ($count >= 2) {
 	       ($yyyy, $mm, $dd, $HH, $MM, $ss) = ( $lastrowx[0] =~ /(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);
        	if(defined($yyyy)) {
                	print "<p>";
                	print "-----警報メール送信-----<br>";
                	print "<table border='0'>";
                	print "<tr><td>送信日時 :</td><td>$lastrowx[0]</td></tr>";
                	print "</table>";
                	print "</p>";
        	} else {
                	print "<p>";
                	print "-----一つ前 アラームデータ-----<br>";
                	print "<table border='0'>";
                	print "<tr><td>$lastrowx[2]</td><td></td></tr>";
                	print "<tr><td>発生日時 :</td><td>$lastrowx[1]</td></tr>";
                	print "<tr><td>$lastrowx[0] :</td><td>$lastrowx[3]</td></tr>";
                	print "<tr><td>警報発生時の計測値 :</td><td>$lastrowx[7]($lastrowx[8])</td></tr>";
                	print "</table>";
                	print "---------警報設定値----------<br>";
                	print "<table border='0'>";
                	if ( $lastrowx[4] == 1 ) {
                        	print "<tr><td>上限警報 :</td><td>上限 $lastrowx[5]($lastrowx[8])</td></tr>";
                	} elsif ( $lastrowx[4] == 2 ) {
                       		print "<tr><td>下限警報 :</td><td>下限 $lastrowx[6]($lastrowx[8])</td></tr>";
                	} elsif ( $lastrowx[4] == 3 ) {
                		print "<tr><td>上下限警報 :</td><td>上限 $lastrowx[5]($lastrowx[8]),下限 $lastrowx[6]($lastrowx[8])</td></tr>";
                	}
                	print "</table>";
                	print "</p>";
                }
	}

	if ($count >= 3) {
              ($yyyy, $mm, $dd, $HH, $MM, $ss) = ( $lastrowx2[0] =~ /(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);
                if(defined($yyyy)) {
                        print "<p>";
                        print "-----警報メール送信-----<br>";
                        print "<table border='0'>";
                        print "<tr><td>送信日時 :</td><td>$lastrowx2[0]</td></tr>";
                        print "</table>";
                        print "</p>";
                } else {
                        print "<p>";
                        print "-----二つ前 アラームデータ-----<br>";
                        print "<table border='0'>";
                        print "<tr><td>$lastrowx2[2]</td><td></td></tr>";
                        print "<tr><td>発生日時 :</td><td>$lastrowx2[1]</td></tr>";
                        print "<tr><td>$lastrowx2[0] :</td><td>$lastrowx2[3]</td></tr>";
                        print "<tr><td>警報発生時の計測値 :</td><td>$lastrowx2[7]($lastrowx2[8])</td></tr>";
                        print "</table>";
                        print "---------警報設定値----------<br>";
                        print "<table border='0'>";
                        if ( $lastrowx2[4] == 1 ) {
                                print "<tr><td>上限警報 :</td><td>上限 $lastrowx2[5]($lastrowx2[8])</td></tr>";
                        } elsif ( $lastrowx2[4] == 2 ) {
                                print "<tr><td>下限警報 :</td><td>下限 $lastrow2x[6]($lastrowx2[8])</td></tr>";
                        } elsif ( $lastrowx2[4] == 3 ) {
                        	print "<tr><td>上下限警報 :</td><td>上限 $lastrowx2[5]($lastrowx2[8]),下限 $lastrowx2[6]($lastrowx2[8])";
                        }
                        print "</table>";
                        print "</p>";
                }
        }

print <<"END";
	--------------------------------------<br>
	</p>
	<p>アラームログ行数: $count</p>
	新しい順にアラームログを表示しています。<br>
	このページは、$refresh_interval秒間隔で自動更新されます。<br>
        --------------------------------------<br>
        <a href="../">TOPページ</a>へ戻る。<br>
	</body></html>

END
}

exit;

