/*
 *	Data reading for DHT11 or DHT22(AM2302,RTH03)　sensor
 *	Original source is
 *	http://www.rpiblog.com/2012/11/interfacing-temperature-and-humidity.html
 *	http://dolls.orz.hm/?p=9000 (spcial thanks)
 *
 * 	2014/7-2015/7
 * 	Modifications For getting by CSV type file by Hiroshima-gas TRI (AN).
 *
 * 	(Example) Compile on Raspberry Pi by gcc trh36.c -o trh -L/usr/local/lib -lwiringPi
 */

#include <wiringPi.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <time.h>

#include "alarm_mail8.h"

#define MAX_TIME 85

int dht_val[5]={0,0,0,0,0};
int res;
int GPIOPIN;
int trhpin[2];				//Use GPIO number (raspi name)
int type;
float f, h;
float tvaluex,hvaluex;			//temporary date of measure

char currentdir[100] = "/usr/local/measure/trh";
static const int OPT_R_MAX = 1800;			//measure interval max 1800 sec (30 minutes)
static const int OPT_R_MIN = 30;			//measure interval min 30 sec
char mbody[10][255];					//alarm mail body part

FILE *fp10;
char *fname10 = "../set/trh.setting";		//temperature and relative humidity measure by DHT11 or DHT22 setting file
int trhchno[2];					//Channel number
int stype[2];					//Sensor type : 11(DHT11) or 22(DHT22)
char trhname[2][31]; 				//the measure name of every channel
int dtat[2];					//Temperature alarm type 0:none 1:upper limit 2:lower limit 3:upper and lower limits
float dtul[2];					//Temperature upper limit
float dtll[2];					//Temperature lower limit
float dtvalue[2];				//Temperature measure value
int dhat[2];					//Relative humidity alarm type 0:none 1:upper limit 2:lower limit 3:upper and lower limits
float dhul[2];					//Relative humidity upper limit
float dhll[2];					//Relative humidity lower limit
float dhvalue[2];				//Relative humidity measure value


FILE *fp20;
char *fname20 = "../set/measure.setting";	//general measure setting file
int intervalsec[5];				//DHT11 or 22  measure interval(sec)
char trh_name[5][51];				//DHT11 or 22 measure project name

FILE *fp30;
char *fname30 = "trh_header.txt";		//header text of logging data

FILE *fp40;
char *fname40 = "../tempdata/trh.csv";		//logging data before FTP upload
char trhtime[100];

FILE *fp50;
char *fname50 = "trhstart.mem";			//memory about amd setting

FILE *fp70;
char *fname70 = "../log/alarm_log/trh_alarm.log";	//alarm logging file
time_t date_old[2][3][3];				//time-memories when alarm occurrence
int moa[2][3][3];					//memories of alarm every channel
int uorl;						//memory of alarm detecrion
time_t nowtime;						//time of alarm occurrence
time_t mailtime[2][3];					//memory of alarm-mail sending time
int sec_time;						//prohibition period of a next send mail
int firsta[2][3];					//memory of the first sending alarm mail


/* recording alarm */
int alarm_record(int torh ,int chno,int uorl)
{

    int rows = 0,rowsx =0 ;
    char buffx[256];

    fp70 = fopen (fname70,"a");
    if (fp70 == NULL) {
	printf("%s ファイルが開けません\n",fname70);
	return -1;
    }
    if (torh==1){
    	switch (uorl) {
		case 1:
			if (stype[chno]==11) fprintf (fp70,"TRH-Ch%dT,%s,Upper level alarm,%s,%d,%0.0f,%0.0f,%0.0f,*C\n",trhchno[chno],trhtime,&trhname[chno],dtat[chno],dtul[chno],dtll[chno],dtvalue[chno]);
			if (stype[chno]==22) fprintf (fp70,"TRH-Ch%dT,%s,Upper level alarm,%s,%d,%0.1f,%0.1f,%0.1f,*C\n",trhchno[chno],trhtime,&trhname[chno],dtat[chno],dtul[chno],dtll[chno],dtvalue[chno]);
			break;
		case 2:
			if (stype[chno]==11) fprintf (fp70,"TRH-Ch%dT,%s,Lower level alarm,%s,%d,%0.0f,%0.0f,%0.0f,*C\n",trhchno[chno],trhtime,&trhname[chno],dtat[chno],dtul[chno],dtll[chno],dtvalue[chno]);
			if (stype[chno]==22) fprintf (fp70,"TRH-Ch%dT,%s,Lower level alarm,%s,%d,%0.1f,%0.1f,%0.1f,*C\n",trhchno[chno],trhtime,&trhname[chno],dtat[chno],dtul[chno],dtll[chno],dtvalue[chno]);
			break;
    	}
    }
    if (torh==2){
    	switch (uorl) {
		case 1:
			if (stype[chno]==11) fprintf (fp70,"TRH-Ch%dH,%s,Upper level alarm,%s,%d,%0.0f,%0.0f,%0.0f,%\n",trhchno[chno],trhtime,&trhname[chno],dhat[chno],dhul[chno],dhll[chno],dhvalue[chno]);
			if (stype[chno]==22) fprintf (fp70,"TRH-Ch%dH,%s,Upper level alarm,%s,%d,%0.1f,%0.1f,%0.1f,%\n",trhchno[chno],trhtime,&trhname[chno],dhat[chno],dhul[chno],dhll[chno],dhvalue[chno]);
			break;
		case 2:
			if (stype[chno]==11) fprintf (fp70,"TRH-Ch%dH,%s,Lower level alarm,%s,%d,%0.0f,%0.0f,%0.0f,%\n",trhchno[chno],trhtime,&trhname[chno],dhat[chno],dhul[chno],dhll[chno],dhvalue[chno]);
			if (stype[chno]==22) fprintf (fp70,"TRH-Ch%dH,%s,Lower level alarm,%s,%d,%0.1f,%0.1f,%0.1f,%\n",trhchno[chno],trhtime,&trhname[chno],dhat[chno],dhul[chno],dhll[chno],dhvalue[chno]);
			break;
    	}
    }

    if ((moa[chno][0][torh] == 1) && (moa[chno][1][torh] == 1) && (moa[chno][2][torh] == 1)) {
	date_old[chno][0][torh] = date_old[chno][1][torh];
	date_old[chno][1][torh] = date_old[chno][2][torh];
	date_old[chno][2][torh] = nowtime;
    }

    if ((moa[chno][0][torh] == 1) && (moa[chno][1][torh] == 1) && (moa[chno][2][torh] == 0)) {
	moa[chno][2][torh] = 1;
	date_old[chno][2][torh] = nowtime;
    }

    if ((moa[chno][0][torh] == 1) && (moa[chno][1][torh] == 0)) {
	moa[chno][1][torh] = 1;
	date_old[chno][1][torh] = nowtime;
    }

    if (moa[chno][0][torh] == 0) {
	moa[chno][0][torh] = 1;
	date_old[chno][0][torh] = nowtime;
    }

    //if (intervalsec[4] <= 180) sec_time = 1800;
    if (intervalsec[4] <= 180) sec_time = 300;
    if ((intervalsec[4] > 180) && (intervalsec[4] <= 600)) sec_time = 3600;
    if (intervalsec[4] >= 600) sec_time = 7200;

    if ((moa[chno][2][torh] == 1) && (date_old[chno][2][torh]-date_old[chno][0][torh] <= sec_time)) {
	sprintf(mbody[0], "温湿度計測(専用センサー) 「 %s 」にて %d (秒) 以内に3回以上の警報が発生しています。\n", &trh_name[4],sec_time);
	sprintf(mbody[1], "\n");
	sprintf(mbody[2], "----------------直近のアラームデータ----------------\n");
	switch(uorl) {
		case 1:
			sprintf(mbody[3],"「上限警報発生」  日時: %s\n",trhtime);break;
		case 2:
 			sprintf(mbody[3],"「下限警報発生」  日時: %s\n",trhtime);break;
	}
	if (torh == 1) {
		sprintf(mbody[4],"TRH_Ch%dT : %s\n",trhchno[chno],&trhname[chno]);
		if (stype[chno]==11) sprintf(mbody[5],"警報発生時の測定値 : %0.0f(*C)\n",dtvalue[chno]);
		if (stype[chno]==22) sprintf(mbody[5],"警報発生時の測定値 : %0.1f(*C)\n",dtvalue[chno]);
	}
	if (torh == 2) {
		sprintf(mbody[4],"TRH_Ch%dH : %s\n",trhchno[chno],&trhname[chno]);
		if (stype[chno]==11) sprintf(mbody[5],"警報発生時の測定値 : %0.0f(%)\n",dhvalue[chno]);
		if (stype[chno]==22) sprintf(mbody[5],"警報発生時の測定値 : %0.1f(%)\n",dhvalue[chno]);
	}
	sprintf(mbody[6],"\n");
	sprintf(mbody[7],"----------------------警報設定値---------------------\n");
	if (torh == 1){
		switch (dtat[chno]) {
			case 1:
				if (stype[chno]==11) sprintf(mbody[8],"上限警報: %0.0f(*C)\n",dtul[chno]);
				if (stype[chno]==22) sprintf(mbody[8],"上限警報: %0.1f(*C)\n",dtul[chno]);
				break;
			case 2:
				if (stype[chno]==11) sprintf(mbody[8],"下限警報: %0.0f(*C)\n",dtll[chno]);
				if (stype[chno]==22) sprintf(mbody[8],"下限警報: %0.1f(*C)\n",dtll[chno]);
				break;
			case 3:
				if (stype[chno]==11) sprintf(mbody[8],"上下限警報:上限 %0.0f(*C),下限 %0.0f(*C)\n",dtul[chno],dtll[chno]);
				if (stype[chno]==22) sprintf(mbody[8],"上下限警報:上限 %0.1f(*C),下限 %0.1f(*C)\n",dtul[chno],dtll[chno]);
				break;
		}
	}

	if(torh==2) {
		switch (dhat[chno]) {
			case 1:
				if (stype[chno]==11) sprintf(mbody[8],"上限警報: %0.0f(*C)\n",dhul[chno]);
				if (stype[chno]==22) sprintf(mbody[8],"上限警報: %0.1f(*C)\n",dhul[chno]);
				break;
			case 2:
				if (stype[chno]==11) sprintf(mbody[8],"下限警報: %0.0f(*C)\n",dhll[chno]);
				if (stype[chno]==22) sprintf(mbody[8],"下限警報: %0.1f(*C)\n",dhll[chno]);
				break;
			case 3:
				if (stype[chno]==11) sprintf(mbody[8],"上下限警報:上限 %0.0f(*C),下限 %0.0f(*C)\n",dhul[chno],dhll[chno]);
				if (stype[chno]==22) sprintf(mbody[8],"上下限警報:上限 %0.1f(*C),下限 %0.1f(*C)\n",dhul[chno],dhll[chno]);
				break;


		}
	}

	if (firsta[chno][torh] == 0) {
		alarm_mail(mbody);
		firsta[chno][torh] = 1;
		mailtime[chno][torh] = nowtime;
		fprintf (fp70,"%s,sent alarm mail\n",trhtime);
		moa[chno][0][torh]=0;
		moa[chno][1][torh]=0;
		moa[chno][2][torh]=0;
	}

	if (firsta[chno][torh] != 0) {
		if (mailtime[chno][torh] + sec_time <= nowtime) {
			alarm_mail(mbody);
			mailtime[chno][torh] = nowtime;
			fprintf (fp70,"%s,sent alarm mail\n",trhtime);
			moa[chno][0][torh]=0;
			moa[chno][1][torh]=0;
			moa[chno][2][torh]=0;
		}
	}
  }

	/* Adjust alarm-log length */

	while (fgets( buffx,256, fp70) != NULL ) rows++;		//count rows of alarm-log
	fclose(fp70);
	rowsx = rows;

	if (rowsx >= 500) {
		FILE *fp75;
		char *fname75="../log/alarm_log/adjusttrh.txt";	//temporary file for alarm log adjusting
		fp70 = fopen(fname70,"r");
		fp75 = fopen(fname75,"w");
		rows =0;

		while (fgets (buffx,256,fp70) != NULL ){
			if (rows >= rowsx -200) fprintf (fp75,buffx);
				rows++;
		}

		fclose(fp75);
		fclose(fp70);
		remove (fname70);
		rename (fname75,fname70);
		remove (fname75);
	}

}





int dht_read_val()
{
  uint8_t lststate=HIGH;
  uint8_t counter=0;
  uint8_t j=0,i;
  float farenheit;
  for(i=0;i<5;i++)
	dht_val[i]=0;
	pinMode(GPIOPIN,OUTPUT);
	digitalWrite(GPIOPIN,LOW);
	delay(18);
	digitalWrite(GPIOPIN,HIGH);
	delayMicroseconds(40);
	pinMode(GPIOPIN,INPUT);
	for(i=0;i<MAX_TIME;i++) {
		counter=0;
		while(digitalRead(GPIOPIN)==lststate){
			counter++;
			delayMicroseconds(1);
			if(counter==255) break;
		}
		lststate=digitalRead(GPIOPIN);
		if(counter==255) break;
    // top 3 transistions are ignored
		if((i>=4)&&(i%2==0)){
			dht_val[j/8]<<=1;
			if(counter>16) dht_val[j/8]|=1;
			j++;
    		}
	}
  // verify cheksum and print the verified data
  	if((j>=40)&&(dht_val[4]==((dht_val[0]+dht_val[1]+dht_val[2]+dht_val[3])&0xFF)))  {

		/* type DHT11 -----Only read dht_val[0] and dht_val[2] because dht_val[1] and dht_val[3] are empty. */
		// Humidity --- dht_val[0]  , Temperature --- dht_val[2]
		if (type == 11) {
			tvaluex = dht_val[2];
			hvaluex = dht_val[0];
		}
		/* type DHT22 */
		// Humidity --- Evaluate dht_val[0] and dht_val[1] as serial binary data,then Divid 10.
		// Temperature --- Evaluate dht_val[2](lower 7bit) and dht_val[3] as serial binary data,then Divid 10.
		// Temperature --- If dht_val[2](top 1bit) is 1,below freesing. If top 1bit is 0, upper than 0 (*C).
		if (type == 22) {
			h = dht_val[0] * 256 + dht_val[1];
 			h /= 10;
			f = (dht_val[2] &0x7F) * 256 + dht_val[3];
			f /= 10;
			if (dht_val[2] &0x80) f *= -1;
			tvaluex = f;
			hvaluex = h;
		}
		return 2;
    	}
}

/* measure and alarm*/
int dht_read_val2()
{
	int ii;
	struct tm *trht;
	int mf[2];
	int trherror[2];

	for (ii=0;ii<2;ii++) {
		tvaluex = 0;
		hvaluex = 0;
 		GPIOPIN = trhpin[ii];
		type = stype[ii];
		mf[ii] = 0;
		trherror[ii] = 0;

		while(1) {
			res = 1;
			res = dht_read_val();
			if(res==2) {		//success to verify getting data
				trherror[ii] = 2;
				break;
			} else {		//fail to verify getting data
				mf[ii]++;
				if (mf[ii] > 15) {		//fail to get data,out of while-loop
					trherror[ii] = 1;
			 		break;
				}
				else {				//re-measure
				trherror[ii] = 0;
				}
				delay(500);
			}
		}
		dtvalue[ii]=tvaluex;
		dhvalue[ii]=hvaluex;
	}

	nowtime = time(NULL);		//get measure time
	trht = localtime(&nowtime);
	strftime(trhtime,100,"%Y/%m/%d %H:%M:%S",trht);

	fp40 = fopen (fname40,"a");
	if(fp40 == NULL) {
		printf(" %s ファイルが開きません\n",fname40);
		return -1;
	}

	for (ii=0;ii<2;ii++){
		if (ii == 0) fprintf(fp40,"%s,",trhtime);
		if (stype[ii] == 11) {
			switch(trherror[ii]){
			case 1:
				fprintf(fp40,"-,-");
				break;
                        case 2:
                                fprintf(fp40,"%0.0f,%0.0f",dtvalue[ii],dhvalue[ii]);
                                break;

			}
		}
		if (stype[ii] == 22) {
                       switch(trherror[ii]){
                        case 1:
                                fprintf(fp40,"-,-");
                                break;
                        case 2:
                                fprintf(fp40,"%0.1f,%0.1f",dtvalue[ii],dhvalue[ii]);
                                break;

                        }
                }

		if (ii < 1) {
			fprintf(fp40,",");
		}else {
			fprintf(fp40,"\n");
		}

		if ((dtvalue[ii] != 0) || (dhvalue[ii] != 0)) {
			// Alarm detection (temperature)
			switch (dtat[ii]) {
			case 1:
				if (dtvalue[ii] > dtul[ii]) alarm_record(1,ii,1);
				break;
 			case 2:
				if (dtvalue[ii] < dtll[ii]) alarm_record(1,ii,2);
				break;
			case 3:
				if (dtvalue[ii] > dtul[ii]) alarm_record(1,ii,1);
				if (dtvalue[ii] < dtll[ii]) alarm_record(1,ii,2);
				break;
			}
			// Alarm detection (relative humidity)
			switch (dhat[ii]) {
			case 1:
				if (dhvalue[ii] > dhul[ii]) alarm_record(2,ii,1);
				break;
 			case 2:
				if (dhvalue[ii] < dhll[ii]) alarm_record(2,ii,2);
				break;
			case 3:
				if (dhvalue[ii] > dhul[ii]) alarm_record(2,ii,1);
				if (dhvalue[ii] < dhll[ii]) alarm_record(2,ii,2);
				break;
			}
		}

	}
	fclose(fp40);
}


/* read setting data */
int readsetting()
{
	int ret10,i10;
	int ret20,i20;
	int xxx1[5],xxx2[5];

	fp10 = fopen( fname10, "r" );
	if( fp10 == NULL ){
		printf( "%s ファイルが開けません\n", fname10 );
		return -1;
  	}
	for (i10 = 0; i10 < 2; i10++) {
		ret10 = fscanf( fp10, "%d,%d,%[^,],%d,%f,%f,%d,%f,%f", &trhchno[i10], &stype[i10], &trhname[i10],&dtat[i10],&dtul[i10],&dtll[i10],&dhat[i10],&dhul[i10],&dhll[i10]);
	}
	fclose(fp10);

	fp20 = fopen( fname20, "r" );
	if( fp20 == NULL ){
		printf( "%s ファイルが開けません\n", fname20 );
		return -1;
	}

	for (i20=0;i20<5;i20++) {
		ret20 = fscanf( fp20, "%d,%d,%[^,],%d", &xxx1[i20], &intervalsec[i20], &trh_name[i20][0] ,&xxx2[i20] );
	}
  	fclose(fp20);
  	if ((intervalsec[4] > OPT_R_MAX) || (intervalsec[4] < OPT_R_MIN) ) {
		printf("計測間隔設定エラー\n");
		return -1;
	}
}

/* make header of csv data file */
int makeheader() {

	char *str30 = "trh-ch_NO,sensor_type,measure_point,T-alarm_type,T-upper_limit,T-lower_limit,H-alarm_type,H-upper_limit,H-lower_limit\n";
	char *str31 = "* sensor type 11:DHT11,22:DHT22 or AM2302 or RTH03\n";
	char *str32 = "* Mean T:temerature,H:relative humidity\n";
 	char *str33 = "* alarm_type 0:None 1:Upper limit alarm 2:Lower limit alarm 3:Upper and lower limits\n";
	int i10;

	fp30 = fopen(fname30,"w");
	if (fp30 == NULL ){
		printf("%sファイルが開けません\n",fname30);
		return -1;
	}
	fprintf(fp30,"%s\n",&trh_name[4]);
	fputs("\n",fp30);

	fputs (str30,fp30);
	for (i10 = 0; i10 < 2; i10++) {
		fprintf(fp30, "%d,%d,%s,%d,%g,%g,%d,%g,%g\n", trhchno[i10], stype[i10], &trhname[i10],dtat[i10],dtul[i10],dtll[i10],dhat[i10],dhul[i10],dhll[i10]);
	}

  	fputs("\n",fp30);
	fputs (str31,fp30);
	fputs (str32,fp30);
  	fputs (str33,fp30);
  	fputs("\n",fp30);
  	fprintf (fp30,",%s,%s,%s,%s\n",&trhname[0],&trhname[0],&trhname[1],&trhname[1]);
	fprintf (fp30,",ch%dT,ch%dH,ch%dT,ch%dH\n",trhchno[0],trhchno[0],trhchno[1],trhchno[1]);
  	fprintf(fp30, "Date,temperature,humidity,temperature,humidity\n");
  	fprintf(fp30, " ,(*C),(%),(*C),(%)\n");

  	fclose (fp30);
	return 0;
}



int main(int argc,char *argv[])
{

	int ssignal;
	time_t timer;
	struct tm *date;
	char str2[256];

	trhpin[0] = 4;		//pin number used by ch0 (not broadcom pin name)
	trhpin[1] = 5;		//pin number used by ch1 (not broadcom pin name)

	time_t last = time(0);
	time_t next;

	int shour,smin,ssec;
	int pastsec1 = 0 ;
	int pastsec2 = 0 ;

	chdir(currentdir);

	readsetting();
 	makeheader();

	// order to be started measure loop
   	while(1) {
		timer=time(NULL);
		date = localtime(&timer);
		strftime (str2,255,"%H",date);
		shour=atoi(str2);
       		strftime (str2,255,"%M",date);
		smin=atoi(str2);
       		strftime (str2,255,"%S",date);
		ssec=atoi(str2);
		pastsec1 = shour*3600 + smin * 60 + ssec;
		if (pastsec1%intervalsec[4] == 0) break;
   	}

   	while(1){
  		if (time(&next) != last){
     			last = next;
     			pastsec2++;
			if (pastsec2 == 1500) {		//remake header every interval 25 minutes (1500 sec)
				readsetting();
				makeheader();
				pastsec2 = 0;
			}
			timer = time(NULL);
			date = localtime(&timer);
			strftime (str2,255,"%H",date);
			shour=atoi(str2);
			strftime (str2,255,"%M",date);
			smin=atoi(str2);
			strftime (str2,255,"%S",date);
			ssec=atoi(str2);
			pastsec1 = shour*3600 + smin * 60 + ssec;

			if (pastsec1%intervalsec[4] == 0 ) {
				if(wiringPiSetup()==-1) exit(1);
				dht_read_val2();
			}

			fp50 = fopen(fname50,"r");
			if (fp50 == NULL) {
				printf("%s ファイルを開けません\n",fname50);
			}
			fscanf (fp50,"%d",&ssignal);
			fclose (fp50);
			if (ssignal == 0 ) break;

			usleep(1000000-5);

		}
	}

chdir("/");
return 0;
}
