#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

#include "alarm_mail8.h"


/*
This program is made for recording by csv file on logger.
the measure using MAX 31855 try by Python.
2015/7 by Hiroshima-gas TRI (AN)

(Example) Compile on Raspberry Pi by gcc tes7.c -o tcs
*/

char currentdir[100] = "/usr/local/measure/tc";   	//current directory name
char mbody[10][255];					//Alarm mail body part
static const int OPT_R_MAX = 1800;			//measure interval max 1800sec (30 minutes)

FILE *fp10;
char *fname10 = "../set/tcs.setting";		//temperature measure by thermocouple setting file
int tcschno[4];				//Channel Number for pulse input (0-3)
int tcstype[4];				//thermocouple type, though it mean 1:K 2:T,MAX31855 measure only type K. 
char tcsname[4][31];			//measure name
int tcsat[4];				//temperature alarm type 0:none 1:upper limit 2:lower limit 3:upper ando lower limits
float tcsul[4];				//temperature upper limit
float tcsll[4];				//temperature lower limit
float tcsvalue[4];			//the temperature value(unit *C) by MAX31855

FILE *fp20;
char *fname20 = "../set/measure.setting";	//General measure setting file
int intervalsec[4];				//measure interval (sec)
char tcs_name[4][51];				//name of measure project

FILE *fp30;
char *fname30 = "tcs_header.txt";	//logging data file header

FILE *fp40;
char *fname40 = "../tempdata/tcs.csv";	//logging data before FTP upload
char tcstime[100];			//time of measure

FILE *fp50;
char *fname50 = "tcsstart.mem";		//memory about pcd setting

FILE *fp70;
char *fname70 ="../log/alarm_log/tcs_alarm.log";	//alarm logging file
time_t date_old[8][3];					//time-memories when alarm occurrence
int moa[8][3];						//memories of alarm every channel
int uorl;						//memory of alarm detecrion
time_t nowtime;						//time of alarm occurrence
time_t mailtime[8];					//memory of alarm-mail sending time
int sec_time;						//prohibition period of a next send mail
int firsta[8];						//memory of the first sending alarm mail


/* recording alarm */
int alarm_record(int chno,int uorl) {

    int rows = 0,rowsx =0 ;
    char buffx[256];

    fp70 = fopen (fname70,"a");
    if (fp70 == NULL) {
	printf("%s ファイルが開けません\n",fname70);
	return -1;
    }

    switch (uorl) {
	case 1:
		fprintf (fp70,"TCS_Ch%d,%s,Upper level alarm,%s,%d,%g,%g,%g,*C\n",tcschno[chno],tcstime,&tcsname[chno],tcsat[chno],tcsul[chno],tcsll[chno],tcsvalue[chno]);
		break;
	case 2:
		fprintf (fp70,"TCS_Ch%d,%s,Lower level alarm,%s,%d,%g,%g,%g,*C\n",tcschno[chno],tcstime,&tcsname[chno],tcsat[chno],tcsul[chno],tcsll[chno],tcsvalue[chno]);
		break;
    }

   if ((moa[chno][0] == 1) && (moa[chno][1] == 1) && (moa[chno][2] == 1)) {
	date_old[chno][0] = date_old[chno][1];
	date_old[chno][1] = date_old[chno][2];
	date_old[chno][2] = nowtime;
    }

    if ((moa[chno][0] == 1) && (moa[chno][1] == 1) && (moa[chno][2] == 0)) {
	moa[chno][2] = 1;
	date_old[chno][2] = nowtime;
    }

    if ((moa[chno][0] == 1) && (moa[chno][1] == 0)) {
	moa[chno][1] = 1;
	date_old[chno][1] = nowtime;
    }

    if (moa[chno][0] == 0) {
	moa[chno][0] = 1;
	date_old[chno][0] = nowtime;
    }

    if (intervalsec[3] <= 180) sec_time = 1800;
    if ((intervalsec[3] > 180) && (intervalsec[3] <= 600)) sec_time = 3600;
    if (intervalsec[3] >= 600) sec_time = 7200;

    if ((moa[chno][2] == 1) && (date_old[chno][2]-date_old[chno][0] <= sec_time)) {

	sprintf(mbody[0], "温度計測S「 %s 」にて %d (秒) 以内に3回以上の警報が発生しています。\n", &tcs_name[3],sec_time);
	sprintf(mbody[1], "\n");
	sprintf(mbody[2], "----------------直近のアラームデータ----------------\n");
	switch(uorl) {
		case 1:
			sprintf(mbody[3],"「上限警報発生」  日時: %s\n",tcstime);break;
		case 2:
 			sprintf(mbody[3],"「下限警報発生」  日時: %s\n",tcstime);break;
	}
	sprintf(mbody[4],"TCS_Ch%d : %s\n",tcschno[chno],&tcsname[chno]);
	sprintf(mbody[5],"警報発生時の測定値 : %g(*C)\n",tcsvalue[chno]);
	sprintf(mbody[6],"\n");
	sprintf(mbody[7],"----------------------警報設定値---------------------\n");
	switch (tcsat[chno]) {
		case 1:
			sprintf(mbody[8],"上限警報: %g(*C)\n",tcsul[chno]);break;
		case 2:
			sprintf(mbody[8],"下限警報: %g(*C)\n",tcsll[chno]);break;
		case 3:
			sprintf(mbody[8],"上下限警報:上限 %g(*C),下限 %g(*C)\n",tcsul[chno],tcsll[chno]);
			break;
	}

	if (firsta[chno] == 0) {
		alarm_mail(mbody);
		firsta[chno] = 1;
		mailtime[chno] = nowtime;
		fprintf (fp70,"%s,sent alarm mail\n",tcstime);
		moa[chno][0]=0;
		moa[chno][1]=0;
		moa[chno][2]=0;
	}

	if (firsta[chno] != 0) {
		if (mailtime[chno] + sec_time <= nowtime) {
			alarm_mail(mbody);
			mailtime[chno] = nowtime;
			fprintf (fp70,"%s,sent alarm mail\n",tcstime);
			moa[chno][0]=0;
			moa[chno][1]=0;
			moa[chno][2]=0;
		}
	}
    }

	/* Adjust alarm-log length */

	while (fgets( buffx,256, fp70) != NULL ) rows++;		//count rows of alarm-log
	fclose(fp70);
	rowsx = rows;

	if (rowsx >= 500) {
		FILE *fp75;
		char *fname75="../log/alarm_log/adjusttcs.txt";	//temporary file for alarm log adjusting
		fp70 = fopen(fname70,"r");
		fp75 = fopen(fname75,"w");
		rows =0;

		while (fgets (buffx,256,fp70) != NULL ){
			if (rows >= rowsx -200) fprintf (fp75,buffx);
				rows++;
		}

		fclose(fp70);
		fclose(fp75);
		remove (fname70);
		rename (fname75,fname70);
		remove (fname75);
	}
}


/* read setting data */

int readsetting()
   {
   int i10,ret10,ret20;
   int xxx1[4],xxx2[4];

   fp10 = fopen (fname10,"r");
    if (fp10 == NULL) {
       printf("%s ファイルが開けません\n",fname10);
       return -1;
   }

   for (i10 = 0; i10 <4; i10++) {
	ret10 = fscanf (fp10,"%d,%d,%[^,],%d,%f,%f",&tcschno[i10],&tcstype[i10],&tcsname[i10][0],&tcsat[i10],&tcsul[i10],&tcsll[i10]);
	}
   fclose(fp10);

   fp20 = fopen (fname20,"r");
    if (fp20 == NULL) {
       printf("%s ファイルが開けません\n",fname20);
       return -1;
   }

   for (i10 = 0; i10 <4; i10++) {
	ret20 = fscanf (fp20,"%d,%d,%[^,],%d",&xxx1[i10],&intervalsec[i10],&tcs_name[i10][0],&xxx2[i10]);
	}
   fclose(fp20);

   for (i10 = 0; i10<4; i10++) {
	if (tcstype[i10] != 1) {
	        printf("熱電対タイプエラー K type only\n");
		return -1;
	}
     }

   if (intervalsec[3]   > OPT_R_MAX) {
	printf("パルスカウンタ測定間隔設定エラー\n");
	return -1;
	}
}



/* make header of csv file */

int makeheader()
   {

    char *str30 = "Ch_NO,tc_type,tcs_measure_point,alarm_type,upper_limit,lower_limit\n";
    char *str31 = "Thermocouple type only 1:K\n";
    char *str32 = "Alarm type 0:none 1:upper limit 2:lower limit 3:upper and lower limits\n";
    int i30;

    fp30 = fopen(fname30,"w");
    if (fp30 == NULL) {
       printf("%s ファイルが開けません\n",fname30);
    return -1;
    }

    fprintf (fp30, "%s",&tcs_name[1][0] );
    fputs("\n",fp30);
    fputs("\n",fp30);

    fputs(str30,fp30);
    fputs("\n",fp30);

    for (i30=0;i30 < 4;i30++) {
	fprintf (fp30,"%d,%d,%s,%d,%g,%g\n",tcschno[i30],tcstype[i30],&tcsname[i30][0],tcsat[i30], (float) tcsul[i30], (float) tcsll[i30]);
    }

    fputs("\n",fp30);
    fputs(str31,fp30);
    fputs(str32,fp30);
    fputs("\n",fp30);

    fprintf (fp30, " ,Ch%d,Ch%d,Ch%d,Ch%d\n",tcschno[0],tcschno[1],tcschno[2],tcschno[3]);
    fprintf (fp30, "%s,%s,%s,%s,%s\n" , "Date",&tcsname[0][0],&tcsname[1][0],&tcsname[2][0],&tcsname[3][0]);
    fprintf (fp30, " ,(*C),(*C),(*C),(*C)\n");

    fclose(fp30);

   return 0;
}

/* measure by python */
int tcsmeasure() {

	int rows = 0;
	int i40;
	char buffx[256];

	system("python tcs.py");	//measure of temperature

	fp40 = fopen(fname40,"r");	//csv-file open for alarm processing
	if (fp40 == NULL) {
		printf( "%s ファイルを開けません。",fname40);
		return -1;
	}

	while(fgets(buffx,256,fp40) != NULL) rows++;
	fclose(fp40);

	sscanf(buffx,"%[^,],%f,%f,%f,%f",&tcstime,&tcsvalue[0],&tcsvalue[1],&tcsvalue[2],&tcsvalue[3]);		//get last low of csv file

	/* Alarm detection */
	for (i40 =0;i40 < 4;i40++) {
		switch (tcsat[i40]) {
		case 1:
			if (tcsvalue[i40] > tcsul[i40]) alarm_record(i40,1);
			break;
		case 2:
			if (tcsvalue[i40] < tcsll[i40]) alarm_record(i40,2);
			break;
		case 3:
			if (tcsvalue[i40] > tcsul[i40]) alarm_record(i40,1);
			if (tcsvalue[i40] < tcsll[i40]) alarm_record(i40,2);
			break;
		}
	}
}


int main(int argc,char *argv[])
{
   int i,ssignal=0;

   time_t timer;
   struct tm *date;
   char str[256];

   time_t last = time(0);
   time_t next;
   int shour,smin,ssec;
   int pastsec1 = 0;
   int pastsec2 = 0;

   /* move to cuurent directory */

   chdir(currentdir);

   /* Read setting data */

   readsetting();
   makeheader();

   /* measure temperaature */


    while (1) {
	timer=time(NULL);			//order to be started measure loop
	date = localtime(&timer);
	strftime(str,255,"%H",date);
	shour = atoi(str);
	strftime(str,255,"%M",date);
	smin = atoi(str);
        strftime(str,255,"%S",date);
	ssec =atoi(str);
	pastsec1 = shour*3600 + smin*60 + ssec;
	if (pastsec1%intervalsec[3] == 0 ) break;
   }

   while (1)
   {
	if (time(&next) != last ) {
		last = next;
		pastsec2++ ;

		if (pastsec2 == 1500) {			//remake header every interval 25min(1500sec)
			readsetting();
			makeheader();
			pastsec2 = 0;
		}


	        timer = time(NULL);
		date = localtime(&timer);
		strftime(str,255,"%H",date);
		shour = atoi(str);
		strftime(str,255,"%M",date);
		smin = atoi(str);
		strftime(str,255,"%S",date);
		ssec =atoi(str);
		pastsec1 = shour*3600 + smin*60 + ssec;
		if (pastsec1%intervalsec[3] == 0 ) {
			nowtime = timer;
			tcsmeasure();
		}
	}
	/* Branch to exit out while loop  */

   	fp50 = fopen(fname50,"r");
	if (fp50 == NULL) {
		printf("%s ファイルが開けません\n",fname50);
		return -1;
	}
	fscanf (fp50,"%d",&ssignal);
	fclose(fp50);

	if (ssignal == 0 ) break;
	usleep(1000000-5);

   }

   chdir ("/");
   return 0;
}

