#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

#include <pigpio.h>
#include "alarm_mail8.h"

/*
2014-08-20 Original source http://abyz.co.uk/rpi/pigpio/code/freq_count_1.zip
2015-06-02 Modified by Hiroshima-gas TRI (AN)
           for counting long trim pulses measure.

After install pigpio,try on the same directory
with pc174.c.

gcc -o pc pc174.c -lpigpio -lrt -lpthread
if start up:
$ sudo echo "1" > ./pcstart.mem
$ sudo ./pc &
if stop:
$  sudo echo "0" > ./pcstart.mem
(It is better to make the script for start-up and stopping.)

This program uses the gpioSetAlertFunc function to request
a callback (the same one) for each gpio to be monitored.
*/

#define MAX_GPIOS 32

#define OPT_R_MIN 1
#define OPT_R_MAX 18000		//measure interval max 30 minutes (18000 deciseconds)
#define OPT_R_DEF 5

#define OPT_S_MIN 1
#define OPT_S_MAX 10
#define OPT_S_DEF 5

static volatile int g_pulse_count[MAX_GPIOS];

static int g_num_gpios = 4;
static int g_gpio[MAX_GPIOS];

static int g_opt_r = OPT_R_DEF;
static int g_opt_s = OPT_S_DEF;

char currentdir[100] = "/usr/local/measure/pc";   	//current directory name
char mbody[10][255];					//Alarm mail body part
int firstt=0;						//memory of the first time measure

FILE *fp10;
char *fname10 = "../set/pc.setting";		//pulse counter setting file
int pchno[4];				//Channel Number for pulse input (0-3)
int type[4];				//0:normal pulse counter 8:event recorder L to H 9:event recorder H to L
int pgpio[4];				//Used GPIO Number(raspberry pi-name-number MAX 32)
int pgpio0=12,pgpio1=16,pgpio2=20,pgpio3=21;	//GPIO number used pulse counter interfaces
char pname[4][31];			//measure name
char punit[4][21];			//measure unit
float pweight[4];			//Pulse weight per a pulse
float pvalue[4];			//value multipled Counter value by pulse weight
int pat[4];				//Pulse alarm type 0:none 1:upper limit 2:lower limit 3:upper ando lower limits
float pul[4];				//Pulse upper limit
float pll[4];				//Pulse lower limit

FILE *fp20;
char *fname20 = "../set/measure.setting";	//General measure setting file
int intervalsec[4];			//measure interval (sec)
char pm_name[4][51];			//name of measure project

FILE *fp30;
char *fname30 = "pc_header.txt";	//logging data file header

FILE *fp40;
char *fname40 = "../tempdata/pc.csv";	//logging data before FTP upload
char pctime[100];			//time of measure

FILE *fp50;
char *fname50 = "pcstart.mem";		//memory about pcd setting

FILE *fp70;
char *fname70 ="../log/alarm_log/pc_alarm.log";		//alarm logging file
time_t date_old[8][3];					//time-memories when alarm occurrence
int moa[8][3];						//memories of alarm every channel
int uorl;						//memory of alarm detecrion
time_t nowtime;						//time of alarm occurrence
time_t mailtime[8];					//memory of alarm-mail sending time
int sec_time;						//prohibition period of a next send mail
int firsta[8];						//memory of the first sending alarm mail

/* recording alarm */
int alarm_record(int gno,int uorl)
{

    int rows = 0,rowsx =0 ;
    char buffx[256];

    fp70 = fopen (fname70,"a");
    if (fp70 == NULL) {
	printf("%s ファイルが開けません\n",fname70);
	return -1;
    }

    switch (uorl) {
	case 1:
		fprintf (fp70,"PC_Ch%d,%s,Upper level alarm,%s,%d,%g,%g,%g,%s\n",pchno[gno],pctime,&pname[gno],pat[gno],pul[gno],pll[gno],pvalue[gno],&punit[gno]);
		break;
	case 2:
		fprintf (fp70,"PC_Ch%d,%s,Lower level alarm,%s,%d,%g,%g,%g,%s\n",pchno[gno],pctime,&pname[gno],pat[gno],pul[gno],pll[gno],pvalue[gno],&punit[gno]);
		break;
    }

   if ((moa[gno][0] == 1) && (moa[gno][1] == 1) && (moa[gno][2] == 1)) {
	date_old[gno][0] = date_old[gno][1];
	date_old[gno][1] = date_old[gno][2];
	date_old[gno][2] = nowtime;
    }

    if ((moa[gno][0] == 1) && (moa[gno][1] == 1) && (moa[gno][2] == 0)) {
	moa[gno][2] = 1;
	date_old[gno][2] = nowtime;
    }

    if ((moa[gno][0] == 1) && (moa[gno][1] == 0)) {
	moa[gno][1] = 1;
	date_old[gno][1] = nowtime;
    }

    if (moa[gno][0] == 0) {
	moa[gno][0] = 1;
	date_old[gno][0] = nowtime;
    }

    if (intervalsec[1] <= 180) sec_time = 1800;
    if ((intervalsec[1] > 180) && (intervalsec[1] <= 600)) sec_time = 3600;
    if (intervalsec[1] >= 600) sec_time = 7200;

    if ((moa[gno][2] == 1) && (date_old[gno][2]-date_old[gno][0] <= sec_time)) {

	sprintf(mbody[0], "パルス計測「 %s 」にて %d (秒) 以内に3回以上の警報が発生しています。\n", &pm_name[1],sec_time);
	sprintf(mbody[1], "\n");
	sprintf(mbody[2], "----------------直近のアラームデータ----------------\n");
	switch(uorl) {
		case 1:
			sprintf(mbody[3],"「上限警報発生」  日時: %s\n",pctime);break;
		case 2:
 			sprintf(mbody[3],"「下限警報発生」  日時: %s\n",pctime);break;
	}
	sprintf(mbody[4],"PC_Ch%d : %s\n",pchno[gno],&pname[gno]);
	sprintf(mbody[5],"警報発生時の測定値 : %g(%s)\n",pvalue[gno],&punit[gno]);
	sprintf(mbody[6],"\n");
	sprintf(mbody[7],"----------------------警報設定値---------------------\n");
	switch (pat[gno]) {
		case 1:
			sprintf(mbody[8],"上限警報: %g(%s)\n",pul[gno],&punit[gno]);break;
		case 2:
			sprintf(mbody[8],"下限警報: %g(%s)\n",pll[gno],&punit[gno]);break;
		case 3:
			sprintf(mbody[8],"上下限警報:上限 %g(%s),下限 %g(%s)\n",pul[gno],&punit[gno],pll[gno],&punit[gno]);
			break;
	}

	if (firsta[gno] == 0) {
		alarm_mail(mbody);
		firsta[gno] = 1;
		mailtime[gno] = nowtime;
		fprintf (fp70,"%s,sent alarm mail\n",pctime);
		moa[gno][0]=0;
		moa[gno][1]=0;
		moa[gno][2]=0;
	}

	if (firsta[gno] != 0) {
		if (mailtime[gno] + sec_time <= nowtime) {
			alarm_mail(mbody);
			mailtime[gno] = nowtime;
			fprintf (fp70,"%s,sent alarm mail\n",pctime);
			moa[gno][0]=0;
			moa[gno][1]=0;
			moa[gno][2]=0;
		}
	}

   }


	/* Adjust alarm-log length */

	while (fgets( buffx,256, fp70) != NULL ) rows++;		//count rows of alarm-log
	fclose(fp70);
	rowsx = rows;

	if (rowsx >= 500) {
		FILE *fp75;
		char *fname75="../log/alarm_log/adjustpc.txt";	//temporary file for alarm log adjusting
		fp70 = fopen(fname70,"r");
		fp75 = fopen(fname75,"w");
		rows =0;

		while (fgets (buffx,256,fp70) != NULL ){
			if (rows >= rowsx -200) fprintf (fp75,buffx);
				rows++;
		}

		fclose(fp70);
		fclose(fp75);
		remove (fname70);
		rename (fname75,fname70);
		remove (fname75);
	}

}



int readsetting()
   {
   int i10,ret10,ret20;
   int xxx1[4],xxx2[4];

   fp10 = fopen (fname10,"r");
    if (fp10 == NULL) {
       printf("%s ファイルが開けません\n",fname10);
       return -1;
   }

   for (i10 = 0; i10 <4; i10++) {
	ret10 = fscanf (fp10,"%d,%d,%[^,],%[^,],%f,%d,%f,%f",&pchno[i10],&type[i10],&pname[i10][0],&punit[i10][0],&pweight[i10],&pat[i10],&pul[i10],&pll[i10]);
	}
   fclose(fp10);
   pgpio[0]=pgpio0;pgpio[1]=pgpio1;pgpio[2]=pgpio2;pgpio[3]=pgpio3;

   fp20 = fopen (fname20,"r");
    if (fp20 == NULL) {
       printf("%s ファイルが開けません\n",fname20);
       return -1;
   }

   for (i10 = 0; i10 <2; i10++) {
	ret20 = fscanf (fp20,"%d,%d,%[^,],%d",&xxx1[i10],&intervalsec[i10],&pm_name[i10][0],&xxx2[i10]);
	}
   fclose(fp20);

   for (i10 = 0; i10<4; i10++) {
	if (pgpio[i10] < 0 && pgpio[i10] > MAX_GPIOS) {
	        printf("GPIO番号エラー\n");
		return -1;
	}
     }

   if (intervalsec[1] * 10  > OPT_R_MAX) {
	printf("パルスカウンタ測定間隔設定エラー\n");
	return -1;
	}
}

int makeheader()
   {

    char *str30 = "Ch_NO,type,pc_measure_point,unit,pc_weight,alarm_type,upper_limit,lower_limit";
    int i30;

    fp30 = fopen(fname30,"w");
    if (fp30 == NULL) {
       printf("%s ファイルが開けません\n",fname30);
    return -1;
    }

    fprintf (fp30, "%s",&pm_name[1][0] );
    fputs("\n",fp30);
    fputs("\n",fp30);

    fputs(str30,fp30);
    fputs("\n",fp30);

    for (i30=0;i30 < 4;i30++) {
	fprintf (fp30,"%d,%d,%s,%s,%g,%d,%g,%g\n",pchno[i30],type[i30],&pname[i30][0],&punit[i30][0], (float) pweight[i30],pat[i30], (float) pul[i30], (float) pll[i30]);
    }

    fputs("\n",fp30);
    fprintf(fp30 ,"Sample rate %d microseconds, Refresh rate %d deciseconds\n",g_opt_s, g_opt_r);
    fprintf(fp30 ,"type 0:normal pulse counter 8:events recorder L to H 9:events recorder H to L\n");
    fprintf(fp30 ,"alarm_type 0:none 1:upper limit 2:lower limit 3:upper and lower limits 4:events alarm\n");
    fputs("\n",fp30);

    fprintf (fp30, " ,Ch%d,Ch%d,Ch%d,Ch%d\n",pchno[0],pchno[1],pchno[2],pchno[3]);
    fprintf (fp30, "%s,%s,%s,%s,%s\n" , "Date",&pname[0][0],&pname[1][0],&pname[2][0],&pname[3][0]);
    fprintf (fp30, " ,(%s),(%s),(%s),(%s)\n" , &punit[0][0],&punit[1][0],&punit[2][0],&punit[3][0]);

    fclose(fp30);

   return 0;
}

void edges(int gpio, int level, uint32_t tick)
{
   /* only record low to high edges */
   if (level == 1) g_pulse_count[gpio]++;
}


int pcmeasure()
{
   int i, mode;
   gpioPulse_t pulse[2];
   int count[MAX_GPIOS];

   int i40;

	if (firstt != 0 ) {

		fp40 = fopen(fname40,"a");
		if (fp40 == NULL) {
			printf("%s ファイルが開けません\n",fname40);
			return -1;
		}

		fprintf (fp40,"%s,",pctime);

		for (i=0; i<g_num_gpios; i++) {
			count[i] = g_pulse_count[g_gpio[i]];
			g_pulse_count[g_gpio[i]] = 0;                   //counter value reset
			pvalue[i] = count[i]*pweight[i];
			if (i == g_num_gpios-1) {
				switch (type[i]) {
					case 0:fprintf(fp40," %g\n",(float) pvalue[i]);break;
					case 8:fprintf(fp40," EVT\n");break;
					case 9:fprintf(fp40," EVT\n");break;
				}
			} else {
				switch (type[i]) {
					case 0:fprintf(fp40," %g,",(float) pvalue[i]);break;
					case 8:fprintf(fp40," EVT,");break;
					case 9:fprintf(fp40," EVT,");break;
				}
			}
		}
		fclose(fp40);

	} else {

		firstt = 1;
		for (i=0; i<g_num_gpios; i++) {
			g_pulse_count[g_gpio[i]] = 0;                   //counter value reset
		}
	}

	/* Alarm detection */
	for (i40=0;i40<g_num_gpios;i40++) {
		switch (pat[i40]) {
			case 1:
				if (pvalue[i40] > pul[i40]) alarm_record(i40,1);
				break;
			case 2:
				if (pvalue[i40] < pll[i40]) alarm_record(i40,2);
				break;
			case 3:
				if (pvalue[i40] > pul[i40]) alarm_record(i40,1);
				if (pvalue[i40] < pll[i40]) alarm_record(i40,2);
		}
	}
}

int main(int argc,char *argv[])
{
   int i,mode;
   gpioPulse_t pulse[2];
   //int count[MAX_GPIOS];
   int ssignal = 0 ;

   time_t timer;
   struct tm *date;
   char str[256];

   time_t last = time(0);
   time_t next;
   int shour,smin,ssec;
   int pastsec1 = 0;
   int pastsec2 = 0;

   /* move to cuurent directory */

   chdir(currentdir);

   /* Read setting data */

   readsetting();

   /* Make the data to monitor and
      the header for csv-recording */

   g_opt_r = intervalsec[1] * 10 ;
   makeheader();

   for (i=0;i<g_num_gpios;i++) g_gpio[i] = pgpio[i];

   gpioCfgClock(g_opt_s, 1, 1);
   if (gpioInitialise()<0) return 1;

   /* monitor g_gpio level changes */

   for (i=0; i<g_num_gpios; i++) {
    	gpioSetAlertFunc(g_gpio[i], edges);
   	mode = PI_INPUT;
	gpioSetMode(g_gpio[i], mode);
   }
   /* events recorder start */
   for (i=0;i<4;i++) {
   	if ((type[i] == 8) || (type[i] == 9)) {
		system("./evt &");
		break;
	}
   }			

   while (1) {
	timer=time(NULL);			//order to be started measure loop
	date = localtime(&timer);
	strftime(str,255,"%H",date);
	shour = atoi(str);
	strftime(str,255,"%M",date);
	smin = atoi(str);
        strftime(str,255,"%S",date);
	ssec =atoi(str);
	pastsec1 = shour*3600 + smin*60 + ssec;
	if (pastsec1%intervalsec[1] == 0 ) {
		break;
    	}
   }

   while (1)
   {
      	if (time(&next) != last ) {
		last = next;
		pastsec2++ ;

		if (pastsec2 == 1500) {			//remake header every interval 25min(1500sec)
			readsetting();
			makeheader();
			pastsec2 = 0;
		}

		timer = time(NULL);
		date = localtime(&timer);
		strftime(str,255,"%H",date);
		shour = atoi(str);
		strftime(str,255,"%M",date);
		smin = atoi(str);
		strftime(str,255,"%S",date);
		ssec =atoi(str);
		pastsec1 = shour*3600 + smin*60 + ssec;
		if (pastsec1%intervalsec[1] == 0 ) {
			strftime(pctime,100, "%Y/%m/%d %H:%M:%S" , date);
			nowtime = timer;
			pcmeasure();
		}

	/* Branch to exit out while loop  */

   		fp50 = fopen(fname50,"r");
   		if (fp50 == NULL) {
        		printf("%s ファイルが開けません\n",fname50);
        		return -1;
   		}
		fscanf (fp50,"%d",&ssignal);
		fclose(fp50);

		if (ssignal == 0 ) break;
		gpioDelay(1000000 -5);
	}
   }

   gpioTerminate();
   chdir ("/");
   return 0;
}

