/*
Event recorder
2015/7
made by Hiroshima-gas TRI (AN).
ex: gcc evt21.c -o evt -L/usr/local/lib -lwiringPi
*/

#include <wiringPi.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <time.h>

#include "alarm_mail8.h"

FILE *fp10;
char *fname10 = "../set/pc.setting";		//pulse counter setting file
int pchno[4];				//Channel Number for pulse input (0-3)
int type[4];				//0:normal pulse counter 8:event recorder L to H 9:event recorder H to L
int pgpio[4];				//Used GPIO Number(raspberry pi-name-number MAX 32)
int pgpio0=12,pgpio1=16,pgpio2=20,pgpio3=21;	//GPIO number used pulse counter interfaces
char pname[4][31];			//measure name
char punit[4][21];			//measure unit
float pweight[4];			//Pulse weight per a pulse
float pvalue[4];			//value multipled Counter value by pulse weight
int pat[4];				//Pulse alarm type 0:none 1:upper limit 2:lower limit 3:upper ando lower limits
float pul[4];				//Pulse upper limit
float pll[4];				//Pulse lower limit

FILE *fp20;
char *fname20 = "../set/measure.setting";	//General measure setting file
int intervalsec[4];			//measure interval (sec)
char pm_name[4][51];			//name of measure project

FILE *fp50;
char *fname50 = "pcstart.mem";		//memory about pcd setting

FILE *fp70;
char *fname70 ="../log/event_log/event.log";		//events and alarms logging file
time_t date_old[8][3];					//time-memories when alarm occurrence
int moa[8][3];						//memories of alarm every channel
int uorl;						//memory of alarm detecrion
time_t nowtime;						//time of alarm occurrence
time_t mailtime[8];					//memory of alarm-mail sending time
int sec_time;						//prohibition period of a next send mail
int firsta[8];						//memory of the first sending alarm mail

char evttime[100];					//event occurrence time
char currentdir[100] = "/usr/local/measure/pc";   	//current directory name
char mbody[10][255];					//Alarm mail body part

/* recording event and alarm */
int event_record(int gno,int horl,int ocu)
{

    int rows = 0,rowsx =0 ;
    char buffx[256];

    fp70 = fopen (fname70,"a");
    if (fp70 == NULL) {
	printf("%s ファイルが開けません\n",fname70);
	return -1;
    }
    if (ocu == 1) {
    	switch (horl) {
		case 8:
			fprintf (fp70,"PC_Ch%d,%s,Event L to H occured,%s,%d\n",pchno[gno],evttime,&pname[gno],pat[gno]);
			break;
		case 9:
			fprintf (fp70,"PC_Ch%d,%s,Event H to L occured,%s,%d\n",pchno[gno],evttime,&pname[gno],pat[gno]);
			break;
    	}

   	if ((moa[gno][0] == 1) && (moa[gno][1] == 1) && (moa[gno][2] == 1)) {
		date_old[gno][0] = date_old[gno][1];
		date_old[gno][1] = date_old[gno][2];
		date_old[gno][2] = nowtime;
    	}

    	if ((moa[gno][0] == 1) && (moa[gno][1] == 1) && (moa[gno][2] == 0)) {
		moa[gno][2] = 1;
		date_old[gno][2] = nowtime;
    	}

    	if ((moa[gno][0] == 1) && (moa[gno][1] == 0)) {
		moa[gno][1] = 1;
		date_old[gno][1] = nowtime;
    	}

    	if (moa[gno][0] == 0) {
		moa[gno][0] = 1;
		date_old[gno][0] = nowtime;
    	}

    	sec_time = 1800;
 
    	if ((moa[gno][2] == 1) && (date_old[gno][2]-date_old[gno][0] <= sec_time)) {
		sprintf(mbody[0], "パルス計測(イベント記録)「 %s 」にて %d (秒) 以内に3回以上のイベントが発生しています。\n", &pm_name[1],sec_time);
		sprintf(mbody[1], "\n");
		sprintf(mbody[2], "----------------直近のイベントデータ----------------\n");
		switch(horl) {
		case 8:
			sprintf(mbody[3],"「L to H イベント発生」\n");break;
		case 9:
 			sprintf(mbody[3],"「H to L イベント発生」\n");break;
		}
		sprintf(mbody[4],"日時: %s\n",evttime);
		sprintf(mbody[5],"PC_Ch%d : %s\n",pchno[gno],&pname[gno]);
		sprintf(mbody[6],"\n");

		if (firsta[gno] == 0) {
			if ((pat[gno]==4)) {
				alarm_mail(mbody);
				fprintf (fp70,"PC_Ch%d,%s,sent event alarm mail,%s,%d\n",pchno[gno],evttime,&pname[gno],pat[gno]);
			}
			firsta[gno] = 1;
			mailtime[gno] = nowtime;
			moa[gno][0]=0;
			moa[gno][1]=0;
			moa[gno][2]=0;
		}

		if (firsta[gno] != 0) {
			if (mailtime[gno] + sec_time <= nowtime) {
				if ((pat[gno]==4)) {
					alarm_mail(mbody);
					fprintf (fp70,"PC_Ch%d,%s,sent event alarm mail,%s,%d\n",pchno[gno],evttime,&pname[gno],pat[gno]);
				}
				mailtime[gno] = nowtime;	
				moa[gno][0]=0;
				moa[gno][1]=0;
				moa[gno][2]=0;
			}
		}
	}
    }

    if (ocu == 0) {
    	switch (horl) {
		case 8:
			fprintf (fp70,"PC_Ch%d,%s,Event L to H terminated,%s,%d\n",pchno[gno],evttime,&pname[gno],pat[gno]);
			break;
		case 9:
			fprintf (fp70,"PC_Ch%d,%s,Event H to L terminated,%s,%d\n",pchno[gno],evttime,&pname[gno],pat[gno]);
			break;
    	}
    }



	/* Adjust alarm-log length */

	while (fgets( buffx,256, fp70) != NULL ) rows++;		//count rows of alarm-log
	fclose(fp70);
	rowsx = rows;

	if (rowsx >= 500) {
		FILE *fp75;
		char *fname75="../log/event_log/adjustevt.txt";		//temporary file for alarm log adjusting
		fp70 = fopen(fname70,"r");
		fp75 = fopen(fname75,"w");
		rows =0;

		while (fgets (buffx,256,fp70) != NULL ){
			if (rows >= rowsx -200) fprintf (fp75,buffx);
				rows++;
		}

		fclose(fp70);
		fclose(fp75);
		remove (fname70);
		rename (fname75,fname70);
		remove (fname75);
	}

}

int readsetting()
   {
   int i10,ret10,ret20;
   int xxx1[5],xxx2[5];

   fp10 = fopen (fname10,"r");
    if (fp10 == NULL) {
       printf("%s ファイルが開けません\n",fname10);
       return -1;
   }

   for (i10 = 0; i10 <4; i10++) {
	ret10 = fscanf (fp10,"%d,%d,%[^,],%[^,],%f,%d,%f,%f",&pchno[i10],&type[i10],&pname[i10][0],&punit[i10][0],&pweight[i10],&pat[i10],&pul[i10],&pll[i10]);
	}
   fclose(fp10);
   pgpio[0]=pgpio0;pgpio[1]=pgpio1;pgpio[2]=pgpio2;pgpio[3]=pgpio3;


   fp20 = fopen (fname20,"r");
    if (fp20 == NULL) {
       printf("%s ファイルが開けません\n",fname20);
       return -1;
   }

   for (i10 = 0; i10 <4; i10++) {
	ret20 = fscanf (fp20,"%d,%d,%[^,],%d",&xxx1[i10],&intervalsec[i10],&pm_name[i10][0],&xxx2[i10]);
	}
   fclose(fp20);
}



int main()
{
	time_t timer;
	struct tm *date;
	char str2[256];

	time_t last = time(0);
	time_t next;

	int ssignal;
	int shour,smin,ssec;
	int pastsec1 = 0,pastsec2 = 0;
	int evtcount[4];
	int memevent[4];

	wiringPiSetupGpio();
	chdir(currentdir);
	readsetting();

	int ii1,ii2;
	for (ii1=0;ii1<4;ii1++) {
		pinMode(pgpio[ii1],INPUT);
	}

	while(1) {
		if (time(&next) != last){
     			last = next;
			timer = time(NULL);
			date = localtime(&timer);
			strftime (str2,255,"%H",date);
			shour=atoi(str2);
			strftime (str2,255,"%M",date);
			smin=atoi(str2);
			strftime (str2,255,"%S",date);
			ssec=atoi(str2);
			pastsec1 = shour*3600 + smin * 60 + ssec;

			pastsec2++ ;
			if (pastsec2 == 1500) {			//read setting file every interval 25min(1500sec)
				readsetting();
				pastsec2 = 0;
			}

			// appear a event or alarm by 2 consencutive detection in interval 2 seconds
			if (pastsec1%2 == 0)  {
				strftime(evttime,100, "%Y/%m/%d %H:%M:%S" , date);
				nowtime = timer;

				for (ii2=0;ii2<4;ii2++) {
					if (type[ii2] == 8){
						if (digitalRead(pgpio[ii2]) == 1) {
							evtcount[ii2]++;
						}
						else {
							if (memevent[ii2] == 1) {
								event_record(ii2,type[ii2],0);
								memevent[ii2] = 0;
							}
							evtcount[ii2] = 0;
						}
						if (evtcount[ii2] >= 2) {
							evtcount[ii2] = 0;
							memevent[ii2] = 1;
							event_record(ii2,type[ii2],1);
						}

					} else if (type[ii2] == 9) {
						if (digitalRead(pgpio[ii2]) == 0) {
							evtcount[ii2]++;
						}
						else {
							if (memevent[ii2] == 1) {
								event_record(ii2,type[ii2],0);
								memevent[ii2] = 0;

							}
							evtcount[ii2] = 0;
						}
						if (evtcount[ii2] >= 2) {
							evtcount[ii2] = 0;
							memevent[ii2] = 1;
							event_record(ii2,type[ii2],1);
						}
					}
				}
				delayMicroseconds(2000000-5);
			}

		}
		/* Branch to exit out while loop(1)  */
   		fp50 = fopen(fname50,"r");
   		if (fp50 == NULL) {
        		printf("%s ファイルが開けません\n",fname50);
        		return -1;
   		}
		fscanf (fp50,"%d",&ssignal);
		fclose(fp50);

		if (ssignal == 0 ) break;

		/* Branch to exit out while loop(2)  */
		if((type[0]==0) && (type[1]==0) && (type[2]==0) && (type[3]==0)) break;
	}
	chdir ("/");
	return 0;
}

