/*
 Controlling start-up and stopping the measure program of logger.
 Copyright(c) 2015 Hiroshima-gas TRI (AN)
 (Ex) gcc cssp15.c -o cssp
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>

char *currentdir="/usr/local/measure";		//current directory

FILE *fp10;
char *fname10 = "./set/cssp.setting";		//setting file to control of start-up and stopping measure program
int ss[5];			    		//signal of start or stop 0:stop or 1:start

FILE *fp90;
char *fname90 = "./am/amstart.mem";		//am: request-state start or stop 1:start request 0:stop request
FILE *fp91;
char *fname91 = "./pc/pcstart.mem";		//pc: request-state start or stop 1:start request 0:stop request
FILE *fp92;
char *fname92 = "./tc/tcastart.mem";		//tca: request-state start or stop 1:start request 0:stop request
FILE *fp93;
char *fname93 = "./tc/tcsstart.mem";		//tcs: request-state start or stop 1:start request 0:stop request
FILE *fp94;
char *fname94 = "./trh/trhstart.mem";		//trh: request-state start or stop 1:start request 0:stop request
int memss[5];					//memory of fp90-fp94

FILE *fp901;
char *fname901 = "/var/lock/am";		//lock-files
FILE *fp911;
char *fname911 = "/var/lock/pc";
FILE *fp921;
char *fname921 = "/var/lock/tca";
FILE *fp931;
char *fname931 = "/var/lock/tcs";
FILE *fp941;
char *fname941 = "/var/lock/trh";
int lockss[5];					//memory of fp901-fp941

/* start-up measure */
int ssopen(int pnr)
{
  switch (pnr) {
	case 0:
		system("./am/amd start");break;
	case 1:
		system("./pc/pcd start");break;
	case 2:
		system("./tc/tcad start");break;
	case 3:
		system("./tc/tcsd start");break;
	case 4:
		system("./trh/trhd start");break;
  }
}

/* stopping measure */
int ssclose(int pnr)
{
  switch (pnr) {
        case 0:
                system("./am/amd stop");break;
        case 1:
                system("./pc/pcd stop");break;
        case 2:
                system("./tc/tcad stop");break;
        case 3:
                system("./tc/tcsd stop");break;
        case 4:
		system("./trh/trhd stop");break;
  }
}


/* read setting data */
int readsetting()
{

  fp10 = fopen( fname10, "r" );
  if( fp10 == NULL ){
	printf( "%s ファイルが開けません\n", fname10 );
	return -1;
  }
  fscanf( fp10, "%d,%d,%d,%d,%d", &ss[0],&ss[1],&ss[2],&ss[3],&ss[4]);
  fclose(fp10);

  fp90 = fopen( fname90, "r" );
  if( fp90 == NULL ){
        printf( "%s ファイルが開けません\n", fname90 );
        return -1;
  }
  fscanf( fp90, "%d", &memss[0]);
  fclose(fp90);

  fp91 = fopen( fname91, "r" );
  if( fp91 == NULL ){
        printf( "%s ファイルが開けません\n", fname91 );
        return -1;
  }
  fscanf( fp91, "%d", &memss[1]);
  fclose(fp91);

  fp92 = fopen( fname92, "r" );
  if( fp92 == NULL ){
        printf( "%s ファイルが開けません\n", fname92 );
        return -1;
  }
  fscanf( fp92, "%d", &memss[2]);
  fclose(fp92);

  fp93 = fopen( fname93, "r" );
  if( fp93 == NULL ){
        printf( "%s ファイルが開けません\n", fname93 );
        return -1;
  }
  fscanf( fp93, "%d", &memss[3]);
  fclose(fp93);

  fp94 = fopen( fname94, "r" );
  if( fp94 == NULL ){
        printf( "%s ファイルが開けません\n", fname94 );
        return -1;
  }
  fscanf( fp94, "%d", &memss[4]);
  fclose(fp94);

  fp901 = fopen( fname901, "r");
  if (fp901 == NULL) {
	lockss[0]=0;}
  else {
	lockss[0]=1;
  }

  fp911 = fopen( fname911, "r");
  if (fp911 == NULL) {
        lockss[1]=0;}
  else {
        lockss[1]=1;
  }

  fp921 = fopen( fname921, "r");
  if (fp921 == NULL) {
        lockss[2]=0;}
  else {
        lockss[2]=1;
  }

  fp931 = fopen( fname931, "r");
  if (fp931 == NULL) {
        lockss[3]=0;}
  else {
        lockss[3]=1;
  }

  fp941 = fopen( fname941, "r");
  if (fp941 == NULL) {
        lockss[4]=0;}
  else {
        lockss[4]=1;
  }


}

int main(int argc, char *argv[])
{
   int i20;

   chdir(currentdir);
   readsetting();

   for (i20=0;i20<5;i20++){
	if ((ss[i20] == 1) && (memss[i20] == 0)) {
		ssopen(i20);
   	}
   	if ((ss[i20] == 0) && (memss[i20] == 1)) {
		ssclose(i20);
   	}
	// When raspberry pi was rebooted,it let to restart the measure.
	if ((ss[i20] == 1) && (memss[i20] == 1) && (lockss[i20] == 0)) {
		ssopen(i20);
	}
   }

   chdir("/");
   return 0;
}
